/*
 * stack.c: PROTOTYPE fixed size array version of stack of integer elements
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "bool.h"
#include "stack.h"

stack empty_stack(void)          /* create an empty stack */
{
	stack s = (stack) malloc(sizeof(*s));
	assert( s != NULL ); /* or return NULL for callers to check */
	s->nel = 0;
	/* initialise elements; not essential, but helps debugging. */
	int i;
	for( i = 0; i<MAXDEPTH; i++ )
	{
		s->data[i] = 0;
	}
	return s;
}

bool isempty(stack s)            /* is the given stack empty? */
{
	return s->nel == 0;
}

int depth(stack s)               /* how many elements on stack? */
{
	return s->nel;
}

void push(element n, stack s)    /* push element n onto stack s */
{
	assert( s->nel < MAXDEPTH ); /* check not full */
	s->nel++;
	s->data[s->nel] = n;
}

element top(stack s)             /* look at the top element of stack */
{
	return -1;
}

element pop(stack s)             /* pop the top element off stack */
{
	return -1;
}

void destroy_stack(stack s)      /* clear up operation, reclaim resources */
{
	if( s != NULL ) free(s);
}

