/*
 *	check.h: useful assert-like macros from H&T p121, modified slightly
 *		using the cute #PARAM pre-processor syntax to mean:
 *		"stringify this param"..
 */

#define CHECK_INT(EXPR, EXPECTED)					   \
	do {								   \
	    int rc = EXPR;						   \
	    if( rc != EXPECTED )					   \
	    {								   \
	        fprintf( stderr, "%s:%d - %s: was %d, expected %d\n",      \
		    __FILE__, __LINE__, #EXPR, rc, EXPECTED );             \
		exit(1);						   \
	    }								   \
	} while(0)

#define CHECK_BOOL(EXPR, EXPECTED)					   \
	do {								   \
	    bool rc = EXPR;						   \
	    if( rc != EXPECTED )					   \
	    {								   \
	        fprintf( stderr, "%s:%d - %s: was %s, expected %s\n",      \
		    __FILE__, __LINE__, #EXPR,				   \
		    bool_as_str(rc), bool_as_str(EXPECTED) );              \
		exit(1);						   \
	    }								   \
	} while(0)

#define CHECK_CHAR(EXPR, EXPECTED)					   \
	do {								   \
	    char rc = EXPR;						   \
	    if( rc != EXPECTED )					   \
	    {								   \
	        fprintf( stderr, "%s:%d - %s: was %c (%d), expected %d\n", \
		    __FILE__, __LINE__, #EXPR, rc, rc, EXPECTED );         \
		exit(1);						   \
	    }								   \
	} while(0)

#define CHECK_STR(EXPR, EXPECTED)					   \
	do {								   \
	    extern int strcmp( char *, char * );			   \
	    char *rc = EXPR;						   \
	    if( strcmp(rc, EXPECTED) != 0 )				   \
	    {								   \
	        fprintf( stderr, "%s:%d - %s: was %s, expected %s\n",      \
		    __FILE__, __LINE__, #EXPR, rc, EXPECTED );             \
		exit(1);						   \
	    }								   \
	} while(0)
