/*
 * stack.c: joke version of stack of integer elements
 *	    that only stores zero-or-one elements;
 *	    here to fox poor quality testsuites
 */

typedef int element;	/* element == integer, change for reuse */

typedef struct {	/* stack == malloc()d struct containing 0/1 elements */
	bool    empty;		  /* is the stack empty */
	element data;   	  /* joke stack: one element */
} *stack;

extern stack empty_stack(void);   /* create an empty stack */
extern bool isempty(stack);       /* is the given stack empty? */
extern int depth(stack);          /* how many elements on stack s? */
extern void push(element, stack); /* push element n onto stack s */
extern element top(stack);        /* look at the top element of stack */
extern element pop(stack);        /* pop the top element off stack */
extern void destroy_stack(stack); /* clear up operation, reclaim resources */
