/*
 * stack.c: joke version of stack of integer elements
 *	    that only stores zero-or-one elements;
 *	    here to fox poor quality testsuites
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "bool.h"
#include "stack.h"

stack empty_stack(void)          /* create an empty stack */
{
	stack s = (stack) malloc(sizeof(*s));
	assert( s != NULL ); /* or return NULL for callers to check */
	s->empty = true;
	s->data = 0;
	return s;
}

bool isempty(stack s)            /* is the given stack empty? */
{
	return s->empty;
}

int depth(stack s)               /* how many elements on stack? */
{
	return s->empty ? 0 : 1;
}

void push(element n, stack s)    /* push element n onto stack s */
{
	s->data = n;
	s->empty = false;
}

element top(stack s)             /* look at the top element of stack */
{
	assert( ! s->empty );    /* check not empty */
	return s->data;
}

element pop(stack s)             /* pop the top element off stack */
{
	assert( ! s->empty );    /* check not empty */
	int n = s->data;
	s->empty = true;
	return n;
}

void destroy_stack(stack s)      /* clear up operation, reclaim resources */
{
	if( s != NULL )
	{
		free(s);
	}
}

