/*
 * test4: the push 2, pop 2 test, refactored.
 */

#include <stdio.h>
#include <stdlib.h>

#include "bool.h"
#include "check.h"
#include "stack.h"

#define CHECK_ELEMENT CHECK_INT

void checkempty( stack s )
{
	CHECK_BOOL( isempty(s), true );
	CHECK_INT( depth(s), 0 );
}

void checknonempty( stack s, int expectd, element expectt )
{
	CHECK_BOOL( isempty(s), false );
	CHECK_INT( depth(s), expectd );
	CHECK_ELEMENT( top(s), expectt );
}

int main( void )
{
	stack s = empty_stack();     checkempty(s);
	push( 20, s );               checknonempty( s, 1, 20 );
	push( 30, s );               checknonempty( s, 2, 30 );
	CHECK_ELEMENT( pop(s), 30 ); checknonempty( s, 1, 20 );
	CHECK_ELEMENT( pop(s), 20 ); checkempty(s);
	destroy_stack(s);
	exit(0);
}
