/*
 * stack.h: PROTOTYPE array-based version of stack of integer elements
 */

typedef int element;	          /* element == integer, change for reuse */

#define MAXDEPTH 100

typedef struct {	          /* stack == fixed size array in a malloc()d struct */
	int nel;		  /* number of elements on the stack */
	element data[MAXDEPTH];   /* elements in data[0..nel-1] */
} *stack;

extern stack empty_stack(void);   /* create an empty stack */
extern bool isempty(stack);       /* is the given stack empty? */
extern int depth(stack);          /* how many elements on stack? */
extern void push(element, stack); /* push element n onto stack */
extern element top(stack);        /* look at the top element of stack */
extern element pop(stack);        /* pop the top element off stack */
extern void destroy_stack(stack); /* clear up operation, reclaim resources */
