/*
 * stack.c: PROTOTYPE fixed size array version of stack of integer elements
 *          bugfixed push() and adjusted top()
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "bool.h"
#include "stack.h"
#include "check.h"

stack empty_stack(void)          /* create an empty stack */
{
	stack s = (stack) malloc(sizeof(*s));
	assert( s != NULL ); /* or return NULL for callers to check */
	s->nel = 0;
	/* initialise elements; not essential, but helps debugging. */
	int i;
	for( i = 0; i<MAXDEPTH; i++ )
	{
		s->data[i] = 0;
	}
	return s;
}

bool isempty(stack s)            /* is the given stack empty? */
{
	return s->nel == 0;
}

int depth(stack s)               /* how many elements on stack? */
{
	return s->nel;
}

void push(element n, stack s)    /* push element n onto stack s */
{
	assert( s->nel < MAXDEPTH ); /* check not full */
	s->data[s->nel] = n;
	s->nel++;
}

element top(stack s)             /* look at the top element of stack */
{
	assert( s->nel > 0 );    /* check not empty */
	return s->data[s->nel-1];
}

element pop(stack s)             /* pop the top element off stack */
{
	assert( s->nel > 0 );    /* check not empty */
	s->nel--;
	int n = s->data[s->nel];
	return n;
}

void destroy_stack(stack s)      /* clear up operation, reclaim resources */
{
	if( s != NULL ) free(s);
}

#define BIGSTRLEN 1024
string stack_as_str(stack s)     /* return displayable form of s    */
{				 /* eg. [30,20,10] -- 30 is the top */
	char *d = malloc(BIGSTRLEN);	/* ridiculously big! */
	int len = 1;
	strcpy( d, "[" );
	int i;
	for( i=s->nel-1; i>=0; i-- )
	{
		char *p = d+strlen(d);
		len += sprintf( p, "%d,", s->data[i] );
		assert( len < BIGSTRLEN );
	}
	if( s->nel > 0 )
	{
		d[strlen(d)-1]='\0';	/* remove trailing comma */
		len--;
	}
	strcat( d, "]" );		/* becomes ] instead */
	len += 2;
	assert( len < BIGSTRLEN );
	return d;			/* CALLER MUST FREE THIS STRING */
}


void check_stack( stack s, char *expected )  /* check stack contents */
{
	string as_str = stack_as_str(s);
	CHECK_STR( as_str, expected );
	free( as_str );
}

