package ProgolInterface;

import myawt.GridBag;
import PrologParse.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

/** 
 * A Panel to allow one to add and view Clauses by predicate symbol.
 * Part of the Progol Interface package.
 * @author Rupert Parson
 * @version 2.0
 * @see ProgolInterface
 */
class ClauseSelectPanel extends Panel
implements ActionListener, ItemListener {

  private ProgolInterface session;
  private List predicates, clauses;
  private Button add, delete, manual;
  private Panel buttonpanel;
  private GridBagLayout gridbag = new GridBagLayout();
  private GridLayout grid = new GridLayout(1,2,20,40);

  /**
   * The constructor.
   * The parent ProgolInterface is passed to the panel
   * as a session so that the panel knows what to display
   * in its various Lists.
   * @param session  The ProgolInterface session.
   */
  public ClauseSelectPanel(ProgolInterface session) {
    this.session = session;

    predicates = new List(15,false);
    predicates.addItemListener(this);
    clauses = new List(13,false);
    clauses.addItemListener(this);

    manual = new Button("Add non-unit Clause");
    manual.addActionListener(this);
    manual.setEnabled(true);

    add = new Button("Add Clause");
    add.addActionListener(this);
    delete = new Button("Delete Clause");
    delete.addActionListener(this);

    buttonpanel = new Panel();
    buttonpanel.setLayout(grid);
    buttonpanel.add(add);
    buttonpanel.add(delete);

    this.setLayout(gridbag);
    GridBag.constrain(this, new Label("Predicates :"), 0, 0, 1, 1,
		      GridBagConstraints.NONE, 
		      GridBagConstraints.NORTHWEST,
		      1.0, 0.0, 10, 10, 0, 10);
    GridBag.constrain(this, predicates, 0, 1, 1, 1, 
		      GridBagConstraints.BOTH,
		      GridBagConstraints.NORTHWEST, 
		      1.0, 1.0, 0, 10, 10, 10);
    GridBag.constrain(this, manual, 0, 2, 1, 1, 
		      GridBagConstraints.HORIZONTAL,
		      GridBagConstraints.NORTHWEST, 
		      1.0, 0.0, 10, 10, 10, 10);
    GridBag.constrain(this, new Label("Clauses :"), 1, 0, 1, 1, 
		      GridBagConstraints.NONE, 
		      GridBagConstraints.NORTHWEST,
		      1.0, 0.0, 10, 10, 0, 10);
    GridBag.constrain(this, clauses, 1, 1, 1, 1, 
		      GridBagConstraints.BOTH,
		      GridBagConstraints.NORTHWEST, 
		      1.0, 1.0, 0, 10, 10, 10);
    GridBag.constrain(this, buttonpanel, 1, 2, 1, 1, 
		      GridBagConstraints.HORIZONTAL,
		      GridBagConstraints.NORTHWEST, 
		      1.0, 0.0, 10, 10, 10, 10);

    this.update();
  }

  /**
   * Update the Panel.
   * Ensures that the information displayed is the same as
   * the information stored in the ProgolInterface session.
   */
  public final void update() {
    add.setEnabled(false);
    delete.setEnabled(false);
    predicates.removeAll();
    clauses.removeAll();
    for (Enumeration e = session.clauses.definitions().keys();
	 e.hasMoreElements();
	 predicates.addItem((String) e.nextElement())) {}
  }

  /**
   * Handle Button press events.
   */
  public final void actionPerformed(ActionEvent event) {
    if (event.getSource() == manual || event.getSource() == add) {
      String s;
      if (event.getSource() == manual) { s = ""; }
      else { s = predicates.getSelectedItem(); }
      ClauseDefineDialog cdd = new ClauseDefineDialog(session, s);
      cdd.setVisible(true);;
      if (!cdd.cancelled()) {
	String cl = cdd.getClause();
	Clause cls = new Clause(cl);
	session.clauses.addElement(cls);
	if (event.getSource() == manual) { update(); }
	else { clauses.addItem(cl);}
      }
    }
    else if (event.getSource() == delete) {
      int pos = clauses.getSelectedIndex();
      session.clauses.removeDefinitionAt(predicates.getSelectedItem(), pos);
      clauses.delItem(pos);
      delete.setEnabled(false);
    }
  }

  /**
   * Handle List selection events.
   */
  public final void itemStateChanged(ItemEvent event) {
    List selected = (List) event.getItemSelectable();
    if (event.getStateChange() == ItemEvent.SELECTED) {
      if (selected == predicates) {
	session.clauses.listDefinition(predicates.getSelectedItem(), clauses);
	add.setEnabled(true);
	delete.setEnabled(false);
      }
      else if (selected == clauses) {
	delete.setEnabled(true);
      }
    }
    else if (event.getStateChange() == ItemEvent.DESELECTED) {
      if (selected == predicates) {
	clauses.removeAll();
	add.setEnabled(false);
	delete.setEnabled(false);
      }
      else if (selected == clauses) {
	delete.setEnabled(false);	
      }
    }
  }
}
