package ProgolInterface;


import myawt.GridBag;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

/** 
 * A Panel to allow one to run a (native) Progol process.
 * The process is run on the contents of the current 
 * ProgolInterface session.
 * One can view, edit, and save the output.
 * Part of the Progol Interface package.
 * @author Rupert Parson
 * @version 2.0
 * @see ProgolInterface
 */
class ProgolExecPanel extends Panel 
implements ActionListener {
  private ProgolInterface session;
  private TextArea output;
  private Button run, stop, save, clear;
  private Process pp;
  
  private GridBagLayout gridbag = new GridBagLayout();

  /**
   * The constructor.
   * The parent ProgolInterface is passed to the panel
   * as a session so that the panel knows what to display
   * in its various Lists.
   * @param session  The ProgolInterface session.
   */
  public ProgolExecPanel(ProgolInterface session) {
    this.session = session;
    output = new TextArea("",24,80,TextArea.SCROLLBARS_VERTICAL_ONLY);
    run = new Button("Run Progol");
    run.addActionListener(this);
	stop = new Button("Stop Progol");
    stop.addActionListener(this);
    save = new Button("Save Output");
    save.addActionListener(this);
    clear = new Button("Clear Output");
    clear.addActionListener(this);

    this.setLayout(gridbag);

    GridBag.constrain(this, new Label("Output:"), 0, 0, 4, 1, 
	      GridBagConstraints.NONE, 
	      GridBagConstraints.NORTHWEST,
	      1.0, 0.0, 10, 10, 0, 10);
    GridBag.constrain(this, output, 0, 1, 4, 1, 
	      GridBagConstraints.BOTH, 
	      GridBagConstraints.NORTHWEST,
	      1.0, 1.0, 0, 10, 10, 10);
    GridBag.constrain(this, run, 0, 2, 1, 1, 
	      GridBagConstraints.HORIZONTAL, 
	      GridBagConstraints.CENTER,
	      1.0, 0.0, 10, 10, 10, 10);		  
    GridBag.constrain(this, stop, 1, 2, 1, 1, 
	      GridBagConstraints.HORIZONTAL, 
	      GridBagConstraints.CENTER,
	      1.0, 0.0, 10, 10, 10, 10);
    GridBag.constrain(this, save, 2, 2, 1, 1, 
	      GridBagConstraints.HORIZONTAL, 
	      GridBagConstraints.CENTER,
	      1.0, 0.0, 10, 10, 10, 10);
    GridBag.constrain(this, clear, 3, 2, 1, 1, 
	      GridBagConstraints.HORIZONTAL, 
	      GridBagConstraints.CENTER,
	      1.0, 0.0, 10, 10, 10, 10);
  }

  private final int runSession()
  {
    session.saveSession("tmppgli.pl");
    Runtime now = Runtime.getRuntime();
   // try {
      try {
	String line;
	pp = now.exec("/usr/jc/bin/progol tmppgli");
	InputStream s = pp.getInputStream();
	BufferedReader in
	  = new BufferedReader(new InputStreamReader(s));
	for (;;) {
	  line = in.readLine();
	  if (line == null) break;
	  output.append(line + "\n");
	}
//	pp.waitFor();
//	return pp.exitValue();
	return 1;
      }
      catch (IOException e) {
	System.out.println("Whoops: " + e);
	return 1;
      }
//    }
//    catch (InterruptedException e) {
//      System.out.println("Whoops: " + e);
//      return 1;
//    }
  }

  private final void saveOutput(String filename) {
    try {
      FileWriter ws = 
	new FileWriter(filename);
      ws.write(output.getText());
      ws.close();
    }
    catch(IOException e) { System.out.println("Whoops: " + e.toString()); }
  }
  
  /**
   * Handle Button press events.
   */
  public final void actionPerformed(ActionEvent event) {
    if (event.getSource() == run) {
      int exitvalue = runSession();
    }
	else if (event.getSource() == stop) {
	  pp.destroy();
	}
    else if (event.getSource() == clear) {
      output.setText("");
    }
    else if (event.getSource() == save) {
      FileDialog fs = new FileDialog(session, "Save Output", FileDialog.SAVE);
      fs.pack();
      fs.show();
      String fn = fs.getFile();
      String fd = fs.getDirectory();
      if (fn != null) { 
	File f = new File(fn,fd);
	if (f.canWrite()) { saveOutput(fd+fn); }
      }
    }
  }
}
