package ProgolInterface;

import myawt.GridBag;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import PrologParse.*;

/** 
 * A Panel to allow one to add types and their elements.
 * Part of the Progol Interface package.
 * @author Rupert Parson
 * @version 2.0
 * @see ProgolInterface
 */
class TypeSelectPanel extends Panel 
implements ActionListener, ItemListener {
  private ProgolInterface session; 
  private Panel lbtnpanel, rbtnpanel;
  private Panel lpanel, rpanel;
  private TextField newtype, newelt;
  private Button addtype, deltype, addelt, delelt;
  private List types, elements;

  private GridBagLayout gridbag = new GridBagLayout();
  private GridLayout grid = new GridLayout(1,2,20,40);

  /**
   * The constructor.
   * The parent ProgolInterface is passed to the panel
   * as a session so that the panel knows what to display
   * in its various Lists.
   * @param session  The ProgolInterface session.
   */
  public TypeSelectPanel(ProgolInterface session) {
    this.session = session;
    
    types = new List(16,false);
    types.addItemListener(this);

    elements = new List(16,false);
    elements.addItemListener(this);

    newtype = new TextField();
    newtype.addActionListener(this);
    newelt = new TextField();
    newelt.addActionListener(this);

    addtype = new Button("Add Type");
    addtype.addActionListener(this);
    deltype = new Button("Delete Type");
    deltype.addActionListener(this);
    lbtnpanel = new Panel();
    lbtnpanel.setLayout(grid);
    lbtnpanel.add(addtype);
    lbtnpanel.add(deltype);

    addelt = new Button("Add Element");
    addelt.addActionListener(this);
    delelt = new Button("Delete Element");
    delelt.addActionListener(this);
    rbtnpanel = new Panel();
    rbtnpanel.setLayout(grid);
    rbtnpanel.add(addelt);
    rbtnpanel.add(delelt);

    lpanel = new Panel();
    lpanel.setLayout(gridbag);
    GridBag.constrain(lpanel, new Label("Defined Types :"), 0, 0, 1, 1,
		      GridBagConstraints.NONE, 
		      GridBagConstraints.NORTHWEST,
		      1.0, 0.0, 10, 0, 0, 0);
    GridBag.constrain(lpanel, types, 0, 1, 1, 1,
		      GridBagConstraints.BOTH, 
		      GridBagConstraints.NORTHWEST, 
		      1.0, 1.0, 0, 0, 10, 0);
    GridBag.constrain(lpanel, new Label("New Type name :"), 0, 2, 1, 1,
		      GridBagConstraints.NONE, 
		      GridBagConstraints.NORTHWEST,
		      1.0, 0.0, 10, 0, 0, 0);
    GridBag.constrain(lpanel, newtype, 0, 3, 1, 1,
		      GridBagConstraints.HORIZONTAL,
		      GridBagConstraints.NORTHWEST, 
		      1.0, 0.0, 0, 0, 10, 0);
    GridBag.constrain(lpanel, lbtnpanel, 0, 4, 1, 1, 
		      GridBagConstraints.HORIZONTAL,
		      GridBagConstraints.NORTHWEST, 
		      1.0, 0.0, 10, 0, 10, 0);

    rpanel = new Panel();
    rpanel.setLayout(gridbag);
    GridBag.constrain(rpanel, new Label("Elements of the Type :"), 0, 0, 1, 1,
		      GridBagConstraints.NONE, 
		      GridBagConstraints.NORTHWEST,
		      1.0, 0.0, 10, 0, 0, 0);
    GridBag.constrain(rpanel, elements, 0, 1, 1, 1, 
		      GridBagConstraints.BOTH, 
		      GridBagConstraints.NORTHWEST, 
		      1.0, 1.0, 0, 0, 10, 0);
    GridBag.constrain(rpanel, new Label("New Element :"), 0, 2, 1, 1,
		      GridBagConstraints.NONE, 
		      GridBagConstraints.NORTHWEST,
		      1.0, 0.0, 10, 0, 0, 0);
    GridBag.constrain(rpanel, newelt, 0, 3, 1, 1, 
		      GridBagConstraints.HORIZONTAL,
		      GridBagConstraints.NORTHWEST, 
		      1.0, 0.0, 0, 0, 10, 0);
    GridBag.constrain(rpanel, rbtnpanel, 0, 4, 1, 1, 
		      GridBagConstraints.HORIZONTAL,
		      GridBagConstraints.NORTHWEST, 
		      1.0, 0.0, 10, 0, 10, 0);

    this.setLayout(gridbag);
    GridBag.constrain(this, lpanel, 0, 0, 1, 1, 
		      GridBagConstraints.BOTH,
		      GridBagConstraints.NORTHWEST, 
		      1.0, 1.0, 0, 10, 0, 10); 
    GridBag.constrain(this, rpanel, 1, 0, 1, 1, 
		      GridBagConstraints.BOTH,
		      GridBagConstraints.NORTHEAST, 
		      1.0, 1.0, 0, 10, 0, 10); 

    this.update();
  }


  /**
   * Update the Panel.
   * Ensures that the information displayed is the same as
   * the information stored in the ProgolInterface session.
   */
  public final void update() {
    newtype.setText("");
    newelt.setText("");
    newelt.setEditable(false);
    newtype.setEditable(true);
    elements.removeAll();
    types.removeAll();
    types.addItem("any/1");
    types.addItem("int/1");
    types.addItem("float/1");
    for (Enumeration e = session.types.definitions().keys();
	 e.hasMoreElements();
	 types.addItem((String) e.nextElement())) {}
  }

  /**
   * Handle Button press events.
   */
  public final void actionPerformed(ActionEvent event) {
    String type,elt;
    if (event.getSource() == deltype && (types.getSelectedIndex() > 2)) {
      if ((type = types.getSelectedItem()) != null) {
	elements.removeAll();
	session.types.removeDefinition(type);
	types.delItem(types.getSelectedIndex());
      }  
      newelt.setEditable(false);
    }
    else if (event.getSource() == delelt) {
      if ((elt = elements.getSelectedItem()) != null) {
	type = types.getSelectedItem();
	Enumeration e = session.types.definition(type).elements();
	while (e.hasMoreElements()) {
	  Clause c = (Clause) e.nextElement();
	  String s = ((Term) c.head().subterms().firstElement()).name();
	  if (elt.equals(s)) { 
	    session.types.removeElement(c);
	  }
	}
	elements.delItem(elements.getSelectedIndex());
      }
    }
    else if (event.getSource() == addtype || event.getSource() == newtype) {
      type = newtype.getText();
      if (type.length() > 0) {
	if (type.endsWith("/1")) {
	  types.addItem(type);
	}
	else {
	  types.addItem(type + "/1");
	}
	newtype.setText("");
      }
      newtype.requestFocus();
    }
    else if (event.getSource() == addelt || event.getSource() == newelt) {
      elt = newelt.getText();
      if (elt.length() > 0) {
	elements.addItem(elt);
	String s = types.getSelectedItem();
	s = s.substring(0,s.lastIndexOf("/")) + "(" + elt + ").";
	session.types.addElement(new Clause(s));
	newelt.setText("");
      }
      newelt.requestFocus();
    }
  }
  
  /**
   * Handle List selection events.
   */
  public final void itemStateChanged(ItemEvent event) {
    List selected = (List) event.getItemSelectable();
    if (event.getStateChange() == ItemEvent.SELECTED) {
      if (selected == types) {
	elements.removeAll();
	if (selected.getSelectedIndex() > 2) {
	  newelt.setEditable(true);
	  Enumeration e = 
	    session.types.
	    definition(selected.getSelectedItem()).elements();
	  while (e.hasMoreElements()) {
	    Clause c = (Clause) e.nextElement();
	    String s = ((Term) c.head().subterms().firstElement()).toString();
	    elements.addItem(s);
	  }
	} 
	else {
	  elements.addItem("*(Progol Built-in)*");
	  newelt.setEditable(false);
	}
      }
    }
    else if (event.getStateChange() == ItemEvent.DESELECTED) {
      if (selected == types) {
	newelt.setEditable(false);
	elements.removeAll();
      }
    }
  }
}
